/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWParticipantHistory;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.api.VWWorkflowHistory;
import java.util.Vector;

public final class VWStepWorkObjectHistory {
    public static final int STATUS_COMPLETED = 0;
    public static final int STATUS_IN_PROGRESS = 1;
    public static final int STATUS_DELETED = 2;
    public static final int STATUS_EXCEPTION = 3;
    public static final int STATUS_GOTO_SUBMAP = 4;
    private VWStepOccurrenceHistory m_occurrenceHistory = null;
    private String m_wobNum;
    private Vector<VWLogElement> m_logElements = new Vector();
    private Vector<VWParticipantHistory> m_participants = new Vector();
    private long m_receivingTime = -1L;
    private long m_completionTime = -1L;
    private int m_status = 1;
    private boolean m_bInitialized = false;
    private boolean m_bInitializing = false;
    private int m_fetchIndex = -1;
    private double m_lastUniqueId = -1.0;
    private int m_bufferSize = 50;
    private int m_lastLogAnalyzed = -1;
    private boolean m_bAnyBoundUser = false;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-08-17 02:01:34 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/4 $";
    }

    VWStepWorkObjectHistory(VWStepOccurrenceHistory occurrenceHistory, String wobNum) {
        this.m_occurrenceHistory = occurrenceHistory;
        this.m_wobNum = wobNum;
        this.m_bInitialized = false;
    }

    public void setBufferSize(int newSize) throws VWException {
        if (newSize < 1) {
            throw new VWException("vw.api.SWOHBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        this.m_bufferSize = newSize;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public boolean hasNext() throws VWException {
        this.initialize();
        return this.m_fetchIndex != -1 && this.m_fetchIndex < this.m_participants.size();
    }

    public void resetFetch() throws VWException {
        this.initialize();
        this.m_fetchIndex = this.m_participants.size() > 0 ? 0 : -1;
    }

    public VWParticipantHistory next() throws VWException {
        this.initialize();
        if (this.m_fetchIndex != -1 && this.m_fetchIndex < this.m_participants.size()) {
            VWParticipantHistory participant = this.m_participants.elementAt(this.m_fetchIndex++);
            return participant;
        }
        return null;
    }

    void doRefresh() throws VWException {
        if (!this.getIsCompleted()) {
            this.m_bInitialized = false;
        }
    }

    VWStepOccurrenceHistory getOccurrenceHistory() {
        return this.m_occurrenceHistory;
    }

    VWStepHistory getStepHistory() {
        return this.m_occurrenceHistory.getStepHistory();
    }

    VWWorkflowHistory getWorkflowHistory() {
        return this.m_occurrenceHistory.getWorkflowHistory();
    }

    public String getWorkObjectNumber() {
        return this.m_wobNum;
    }

    VWParticipantHistory getParticipant(int uId) throws VWException {
        this.initialize();
        if (this.m_participants == null || this.m_participants.size() == 0) {
            return null;
        }
        for (int i = this.m_participants.size() - 1; i >= 0; --i) {
            VWParticipantHistory participant = this.m_participants.elementAt(i);
            double thisUId = participant.getFirstUniqueId();
            if (Double.compare(uId, thisUId) < 0) continue;
            return participant;
        }
        return null;
    }

    void addLogElement(VWLogElement logElement) throws VWException {
        try {
            int lsize;
            int index = -1;
            int i = 0;
            double uniqueId = logElement.getUniqueId();
            int sequence = logElement.getSequenceNumber();
            long time = logElement.getTimeStamp().getTime();
            for (i = 0; i < this.m_logElements.size(); ++i) {
                VWLogElement element = this.m_logElements.elementAt(i);
                long time1 = element.getTimeStamp().getTime();
                double uniqueId1 = element.getUniqueId();
                if (0 == Double.compare(uniqueId, uniqueId1)) {
                    if (time == time1) {
                        int sequence1 = element.getSequenceNumber();
                        if (sequence == sequence1) {
                            return;
                        }
                        if (sequence >= sequence1) continue;
                        break;
                    }
                    if (time >= time1) continue;
                    break;
                }
                if (Double.compare(uniqueId, uniqueId1) < 0) break;
            }
            if ((index = i) == (lsize = this.m_logElements.size())) {
                this.m_logElements.addElement(logElement);
            } else {
                this.m_logElements.insertElementAt(logElement, index);
            }
            if (logElement.getBoundUserId() > 0) {
                this.m_bAnyBoundUser = true;
            }
            if (this.m_lastUniqueId == -1.0 || Double.compare(uniqueId, this.m_lastUniqueId) > 0) {
                this.m_lastUniqueId = uniqueId;
            }
            int operationId = -1;
            Object obj = logElement.getFieldValue("F_OperationId");
            if (obj != null && obj instanceof Integer) {
                operationId = (Integer)obj;
            }
            int eventType = logElement.getEventType();
            switch (eventType) {
                case 352: {
                    if (index == 0) {
                        this.updateReceivingTime(logElement.getTimeStamp().getTime());
                    }
                    this.m_status = 1;
                    break;
                }
                case 170: {
                    if (index == 0) {
                        this.updateReceivingTime(logElement.getTimeStamp().getTime());
                    }
                    this.m_status = 3;
                    break;
                }
                case 405: {
                    if (index == 0) {
                        this.updateReceivingTime(logElement.getTimeStamp().getTime());
                    }
                    this.m_status = 4;
                    break;
                }
                case 100: {
                    if (operationId == 5) {
                        this.m_status = 4;
                    } else {
                        if (!VWParticipantHistory.isSystemInstructionsOperation(operationId)) break;
                        this.m_completionTime = logElement.getTimeStamp().getTime();
                        this.m_status = 0;
                    }
                    if (index == 0) {
                        this.updateReceivingTime(logElement.getTimeStamp().getTime());
                    }
                    break;
                }
                case 140: 
                case 190: 
                case 200: 
                case 360: 
                case 407: {
                    this.m_completionTime = logElement.getTimeStamp().getTime();
                    if (eventType == 360 || eventType == 140 || eventType == 407) {
                        if (index == 0) {
                            this.updateReceivingTime(logElement.getTimeStamp().getTime());
                        }
                        this.m_status = 0;
                        break;
                    }
                    this.m_status = 2;
                    break;
                }
                case 500: {
                    this.m_completionTime = logElement.getTimeStamp().getTime();
                    if (index == 0) {
                        this.updateReceivingTime(logElement.getTimeStamp().getTime());
                    }
                    this.m_status = 0;
                    break;
                }
                default: {
                    if (operationId == 38) {
                        this.m_completionTime = logElement.getTimeStamp().getTime();
                        if (index == 0) {
                            this.updateReceivingTime(logElement.getTimeStamp().getTime());
                        }
                        this.m_status = 0;
                        return;
                    }
                    break;
                }
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
    }

    void updateReceivingTime(long time) throws VWException {
        if (this.m_receivingTime == -1L || time < this.m_receivingTime) {
            this.m_receivingTime = time;
            this.m_occurrenceHistory.updateReceivingTime(time);
        }
    }

    public boolean getIsCompleted() throws VWException {
        this.initialize();
        return this.m_completionTime != -1L;
    }

    long getCompletionTime() throws VWException {
        this.initialize();
        return this.m_completionTime;
    }

    int getStatus() throws VWException {
        this.initialize();
        return this.m_status;
    }

    void initialize() throws VWException {
        if (this.m_bInitializing || this.m_bInitialized) {
            return;
        }
        try {
            this.m_bInitializing = true;
            if (!this.m_bInitialized) {
                this.m_bInitializing = true;
                if (this.m_logElements != null && this.m_logElements.size() > 0) {
                    int status;
                    int index = 0;
                    VWParticipantHistory participant = null;
                    if (this.m_participants.size() > 0 && (status = (participant = this.m_participants.lastElement()).getStepStatus()) != 1) {
                        participant = null;
                    }
                    index = this.m_lastLogAnalyzed + 1;
                    while (index < this.m_logElements.size()) {
                        int eventType;
                        VWLogElement logElement = null;
                        if ((logElement = this.m_logElements.elementAt(index++)) == null) continue;
                        int operationId = -1;
                        Object obj = logElement.getFieldValue("F_OperationId");
                        if (obj != null && obj instanceof Integer) {
                            operationId = (Integer)obj;
                        }
                        if ((eventType = logElement.getEventType()) == 352 || eventType == 170 || eventType == 140 || eventType == 500 || eventType == 100 && operationId == 5 || operationId == 38 || eventType == 100 && VWParticipantHistory.isSystemInstructionsOperation(operationId)) {
                            participant = new VWParticipantHistory(this);
                            this.m_participants.addElement(participant);
                            participant.addLogElement(logElement);
                            continue;
                        }
                        if (participant == null) continue;
                        participant.addLogElement(logElement);
                        switch (eventType) {
                            case 190: 
                            case 200: 
                            case 360: 
                            case 370: 
                            case 382: 
                            case 384: 
                            case 386: {
                                participant = null;
                            }
                        }
                    }
                    this.m_lastLogAnalyzed = this.m_logElements.size() - 1;
                }
                this.m_bInitialized = true;
            }
        }
        catch (VWException ex) {
            throw ex;
        }
        finally {
            this.m_bInitializing = false;
            if (this.m_fetchIndex == -1 && this.m_participants.size() > 0) {
                this.m_fetchIndex = 0;
            }
        }
    }

    public int getStepId() {
        return this.m_occurrenceHistory.getStepId();
    }

    String getWorkflowNumber() {
        return this.m_occurrenceHistory.getWorkflowNumber();
    }

    String getEventLogName() {
        return this.m_occurrenceHistory.getEventLogName();
    }

    int getInstructionSheetId() {
        return this.m_occurrenceHistory.getInstructionSheetId();
    }

    VWSession getSession() {
        return this.m_occurrenceHistory.getSession();
    }

    boolean getIsAnyBoundUser() {
        return this.m_bAnyBoundUser;
    }
}

